---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Closure Strength (diagnostic)

> Loop strength of stabilization (⊚): how firmly a Form is held against perturbations.

---

## Definition

- Form holding power
- Loop binding force
- Stability strength
- Closure firmness

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Hold power | State grip | `Monitor`, `Hold` |
| Loop force | Bind strength | `Check`, `Bind` |
| Stay firm | Keep stable | `Test`, `Keep` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Hold power | Stays strong | "Holds firm" |
| Loop force | Keeps shape | "Stays whole" |
| Stay firm | Stays self | "Keeps form" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| State grip | Stays strong | How hold works |
| Bind strength | Keeps shape | How form stays |
| Keep stable | Stays self | How self holds |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Force hold | Energy bind |
| Networks | State keep | Link hold |
| Cognition | Pattern hold | Mind keep |
| Systems | Flow bind | Form stay |

---

## Scale Effects

How Closure Strength manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum hold | Wave bind |
| λV | Gate keep | State grip |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase hold | Pattern keep |
| ∇S | Structure bind | Clear hold |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave bind | Light hold |
| λV | Field keep | Space grip |

Note: At extreme scales, closure faces fundamental limits (e.g., quantum binding at ε, causal holds at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: hold tolerance
- π: loop geometry
- ψA: phase strength
- λV: gate firm

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern hold | Wave bind |
| Human | λV | Gate grip | Flow keep |
| Cosmic | ψA | Phase bind | Field hold |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Grip loss | Pattern slip | Won't hold |
| Human | Bind fail | Flow leak | Can't keep |
| Cosmic | Hold break | Field slip | Lost grip |

---

## Diagnostic Checklist

Technical tests:
- [ ] Hold measured
- [ ] Bind checked
- [ ] Keep tracked
- [ ] Form stable

Humane tests:
- [ ] Stays strong
- [ ] Keeps shape
- [ ] Self holds
- [ ] Form firm

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical binding nor experiential holding alone captures its full meaning.

---

## See Also

- [[Stability Margin (diagnostic)]]
- [[Resilience (diagnostic)]]
- [[Brittleness (diagnostic)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented